IF EXISTS ( SELECT 1 FROM SYS.TRIGGERS WHERE NAME = 'TRG_ATUALIZA_PCR_SISTEMAS_CTR_VERSAO_TOTAL' )
BEGIN
	DROP TRIGGER TRG_ATUALIZA_PCR_SISTEMAS_CTR_VERSAO_TOTAL
END
GO
CREATE TRIGGER TRG_ATUALIZA_PCR_SISTEMAS_CTR_VERSAO_TOTAL
ON PRC_SISTEMAS_CTR_VERSAO
AFTER INSERT, UPDATE
AS
BEGIN
    SET NOCOUNT ON;

    IF ((SELECT TRIGGER_NESTLEVEL()) > 1) RETURN;

    -- Lidar com insero ou atualizao
    MERGE INTO PRC_SISTEMAS_CTR_VERSAO_TOTAL AS PRC_TOTAL
    USING (SELECT CD_CTR, CD_USU, DT_HR_LOGIN, END_IP, MAQUINA, SISTEMA, VERSAO FROM inserted) AS PRC
    ON PRC_TOTAL.CD_CTR = PRC.CD_CTR

    -- Se j existir, atualize
    WHEN MATCHED THEN 
        UPDATE
    SET
        CD_CTR = PRC.CD_CTR,
        CD_USU = PRC.CD_USU,
        DT_HR_LOGIN = PRC.DT_HR_LOGIN,
        END_IP = PRC.END_IP,
        MAQUINA = PRC.MAQUINA,
        SISTEMA = PRC.SISTEMA,
        VERSAO = PRC.VERSAO

    -- Se no existir, insira
    WHEN NOT MATCHED THEN
    INSERT
        (CD_CTR,
        CD_USU,
        DT_HR_LOGIN,
        END_IP,
        MAQUINA,
        SISTEMA,
        VERSAO)
    VALUES (PRC.CD_CTR,
        PRC.CD_USU,
        PRC.DT_HR_LOGIN,
        PRC.END_IP,
        PRC.MAQUINA,
        PRC.SISTEMA,
        PRC.VERSAO);
END

